// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_input_repeat.h
 *  \brief      MGL リピート入力関連定義
 *  \date       Since: October 29, 2021. 12:21:59 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_INPUT_REPEAT_H_1635477719
#define INCGUARD_MGL_INPUT_REPEAT_H_1635477719

namespace MGL::Input
{
//! リピートタイプ
enum class RepeatType : uint8_t
{
    Frame,     //!< フレーム
    Second,    //!< 秒
};

//! リピート設定
struct RepeatSetting
{
    RepeatType type;      //!< リピートタイプ
    float firstBlank;     //!< 初回ブランク期間
    float secondBlank;    //!< 2回目以降のブランク期間

    //! コンストラクタ
    constexpr RepeatSetting() noexcept
        : type(RepeatType::Second)
        , firstBlank(0.5f)
        , secondBlank(0.067f)
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     *  \param[in]  repeatType      リピートタイプ
     *  \param[in]  inFirstBlank    初回ブランク期間
     *  \param[in]  inSecondBlank   2回目以降のブランク期間
     */
    /* ------------------------------------------------------------------------- */
    constexpr RepeatSetting(RepeatType repeatType, float inFirstBlank, float inSecondBlank) noexcept
        : type(repeatType)
        , firstBlank(inFirstBlank)
        , secondBlank(inSecondBlank)
    {
    }
};
}    // namespace MGL::Input

#endif    // INCGUARD_MGL_INPUT_REPEAT_H_1635477719

// vim: et ts=4 sw=4 sts=4
