// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_input_bounds.h
 *  \brief      MGL 入力範囲
 *  \date       Since: January 1, 2021. 14:24:29 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_INPUT_BOUNDS_H_1609478669
#define INCGUARD_MGL_INPUT_BOUNDS_H_1609478669

#include <mgl/math/mgl_rectangle.h>
#include <mgl/math/mgl_vector2.h>

namespace MGL::Input
{
//! MGL 入力範囲
class InputBounds
{
public:
    InputBounds() noexcept;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      この範囲が有効かを取得
     *  \retval     true    有効
     *  \retval     false   無効
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr bool IsValid() const noexcept
    {
        return ((_bounds.width > 0.0f) && (_bounds.height > 0.0f));
    }

    void Set(const Rectangle &bounds) noexcept;
    void SetWithLogicalSize(const Rectangle &bounds, const Vector2 &logicalSize) noexcept;
    void SetWithScale(const Rectangle &bounds, const Vector2 &scale) noexcept;

    [[nodiscard]] Vector2 GetPosition(const Vector2 &position) const noexcept;

private:
    Rectangle _bounds;
    Vector2 _scale;
};
}    // namespace MGL::Input

#endif    // INCGUARD_MGL_INPUT_BOUNDS_H_1609478669

// vim: et ts=4 sw=4 sts=4
