// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_keyboard_keycode.h
 *  \brief      MGL キーボード用キーコード定義
 *  \date       Since: December 26, 2020. 21:46:40 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_KEYBOARD_KEYCODE_H_1608986800
#define INCGUARD_MGL_KEYBOARD_KEYCODE_H_1608986800

#include <array>
#include <bitset>
#include <cstdint>
#include <type_traits>

namespace MGL::Input
{
//! キーボード用コード
enum class Keycode : uint8_t
{
    Invalid,        //!< 無効
    KeyA,           //!< A
    KeyB,           //!< B
    KeyC,           //!< C
    KeyD,           //!< D
    KeyE,           //!< E
    KeyF,           //!< F
    KeyG,           //!< G
    KeyH,           //!< H
    KeyI,           //!< I
    KeyJ,           //!< J
    KeyK,           //!< K
    KeyL,           //!< L
    KeyM,           //!< M
    KeyN,           //!< N
    KeyO,           //!< O
    KeyP,           //!< P
    KeyQ,           //!< Q
    KeyR,           //!< R
    KeyS,           //!< S
    KeyT,           //!< T
    KeyU,           //!< U
    KeyV,           //!< V
    KeyW,           //!< W
    KeyX,           //!< X
    KeyY,           //!< Y
    KeyZ,           //!< Z
    Key1,           //!< 1
    Key2,           //!< 2
    Key3,           //!< 3
    Key4,           //!< 4
    Key5,           //!< 5
    Key6,           //!< 6
    Key7,           //!< 7
    Key8,           //!< 8
    Key9,           //!< 9
    Key0,           //!< 0
    Return,         //!< Return or Enter
    Escape,         //!< Escape
    Backspace,      //!< Backspace
    Tab,            //!< Tab
    Space,          //!< Space
    F1,             //!< F1
    F2,             //!< F2
    F3,             //!< F3
    F4,             //!< F4
    F5,             //!< F5
    F6,             //!< F6
    F7,             //!< F7
    F8,             //!< F8
    F9,             //!< F9
    F10,            //!< F10
    F11,            //!< F11
    F12,            //!< F12
    Delete,         //!< Delete
    Right,          //!< →
    Left,           //!< ←
    Down,           //!< ↓
    Up,             //!< ↑
    LeftControl,    //!< 左Ctrl
    LeftShift,      //!< 左Shift
    LeftAlt,        //!< 左Option or 左Alt
    LeftGUI,        //!< 左Command or 左Windows
    RightControl,   //!< 右Ctrl
    RightShift,     //!< 右Shift
    RightAlt,       //!< 右Option or 右Alt
    RightGUI,       //!< 右Command or 右Windows
    Control,        //!< Ctrlキー（左右共通）
    Shift,          //!< Shiftキー（左右共通）
    Alt,            //!< Option or Altキー（左右共通）
    GUI,            //!< Command or Windowsキー（左右共通）
};

//! 有効なキーコードの数
constexpr auto kKeycodeCount = static_cast<size_t>(Keycode::GUI) + 1;

//! キーコード用配列のエイリアス
using KeycodeArray = std::bitset<kKeycodeCount>;
}    // namespace MGL::Input
#endif    // INCGUARD_MGL_KEYBOARD_KEYCODE_H_1608986800

// vim: et ts=4 sw=4 sts=4
