// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_keyboard_delegate_win32.h
 *  \brief      MGL Win32用キーボードデリゲート
 *  \date       Since: March 30, 2021. 12:43:29 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_KEYBOARD_DELEGATE_WIN32_H_1617075809
#define INCGUARD_MGL_KEYBOARD_DELEGATE_WIN32_H_1617075809

#include <mgl/mgl_environment.h>
#if defined(MGL_KEYBOARD_DELEGATE_ENABLE_WIN32)

#include <mgl/input/keyboard/mgl_keyboard_delegate.h>

namespace MGL::Input
{
//! Win32用キーボードデリゲート
class Win32KeyboardDelegate : public KeyboardDelegate
{
public:
    void UpdateState(KeycodeArray &state) noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      キーボードが接続されているかを取得
     *  \retval     true    接続されている
     *  \retval     false   接続されていない
     */
    /* ------------------------------------------------------------------------- */
    bool IsConnecting() const noexcept override
    {
        return true;
    }

private:
};

}    // namespace MGL::Input

#endif    // MGL_KEYBOARD_DELEGATE_ENABLE_WIN32
#endif    // INCGUARD_MGL_KEYBOARD_DELEGATE_WIN32_H_1617075809

// vim: et ts=4 sw=4 sts=4
