// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_keyboard_delegate_event.h
 *  \brief      MGL イベントコールバックによるキーボード入力デリゲート
 *  \date       Since: December 27, 2020. 18:07:46 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_KEYBOARD_DELEGATE_EVENT_H_1609060066
#define INCGUARD_MGL_KEYBOARD_DELEGATE_EVENT_H_1609060066

#include <mgl/mgl_environment.h>
#if defined(MGL_KEYBOARD_DELEGATE_ENABLE_EVENT)

#include <mgl/event/mgl_event.h>
#include <mgl/input/keyboard/mgl_keyboard_delegate.h>

namespace MGL::Input
{
//! イベントコールバックによるキーボード入力デリゲートクラス
class EventKeyboardDelegate : public KeyboardDelegate
{
public:
    EventKeyboardDelegate() noexcept;

    void UpdateState(KeycodeArray &state) noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      キーボードが接続されているかを取得
     *  \retval     true    接続されている
     *  \retval     false   接続されていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsConnecting() const noexcept override
    {
        return true;    // このデリゲートは常に接続されているものとする
    }

private:
    static void OnEventKeyDown(void *callbackArg, void *notifyArg) noexcept;
    static void OnEventKeyUp(void *callbackArg, void *notifyArg) noexcept;
    static void OnEventShouldClearInput(void *callbackArg, void *notifyArg) noexcept;

    void SetState(Keycode keycode, bool isPressed) noexcept;

    Event::Handle _eventKeyDown;
    Event::Handle _eventKeyUp;
    Event::Handle _eventShouldClearInput;

    KeycodeArray _temporaryState;
};
}    // namespace MGL::Input

#endif    // MGL_KEYBOARD_DELEGATE_ENABLE_EVENT
#endif    // INCGUARD_MGL_KEYBOARD_DELEGATE_EVENT_H_1609060066

// vim: et ts=4 sw=4 sts=4
