// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_keyboard_delegate_apple_gc.h
 *  \brief      Apple GameControllerフレームワークによるキーボードデリゲート
 *  \date       Since: July 5, 2022. 1:24:33 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_KEYBOARD_DELEGATE_APPLE_GC_H_1656951873
#define INCGUARD_MGL_KEYBOARD_DELEGATE_APPLE_GC_H_1656951873

#include <mgl/mgl_environment.h>

#if defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)

#include <mgl/input/keyboard/mgl_keyboard_delegate.h>

namespace MGL::Input
{
//! Apple GameControllerフレームワークによるキーボードデリゲート
class AppleGCKeyboardDelegate : public KeyboardDelegate
{
public:
    static bool IsAvailable() noexcept;

    AppleGCKeyboardDelegate() noexcept;

    void UpdateState(KeycodeArray &state) noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      キーボードが接続されているかを取得
     *  \retval     true    接続されている
     *  \retval     false   接続されていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] bool IsConnecting() const noexcept override
    {
        return _isConnecting;
    }

private:
    bool _isConnecting;
};
}   // namespace MGL::Input

#endif  // defined(MGL_TARGET_MACOS) || defined(MGL_TARGET_IOS) || defined(MGL_TARGET_TVOS)
#endif	// INCGUARD_MGL_KEYBOARD_DELEGATE_APPLE_GC_H_1656951873

// vim: et ts=4 sw=4 sts=4
