// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_keyboard_delegate.h
 *  \brief      MGL キーボード入力デリゲート基底クラス
 *  \date       Since: December 26, 2020. 21:29:31 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_KEYBOARD_DELEGATE_H_1608985771
#define INCGUARD_MGL_KEYBOARD_DELEGATE_H_1608985771

#include <mgl/input/keyboard/mgl_keyboard_keycode.h>

namespace MGL::Input
{
//! キーボード入力デリゲート基底クラス
class KeyboardDelegate
{
public:
    virtual ~KeyboardDelegate() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief       入力状態の更新処理
     *  \param[out]  state      入力状態の格納先
     */
    /* ------------------------------------------------------------------------- */
    virtual void UpdateState(KeycodeArray &state) noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      キーボードが接続されているかを取得
     *  \retval     true    接続されている
     *  \retval     false   接続されていない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual bool IsConnecting() const noexcept = 0;
};
}    // namespace MGL::Input

#endif    // INCGUARD_MGL_KEYBOARD_DELEGATE_H_1608985771

// vim: et ts=4 sw=4 sts=4
