// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_gamepad_delegate_xinput.h
 *  \brief      MGL XInputゲームパッドデリゲート
 *  \date       Since: April 1, 2021. 15:27:30 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_GAMEPAD_DELEGATE_XINPUT_H_1617258450
#define INCGUARD_MGL_GAMEPAD_DELEGATE_XINPUT_H_1617258450

#include <mgl/mgl_environment.h>
#if defined(MGL_GAMEPAD_DELEGATE_ENABLE_XINPUT)

#include <mgl/input/gamepad/mgl_gamepad_delegate.h>
#include <mgl/input/gamepad/mgl_gamepad_state.h>
#include <array>

namespace MGL::Input
{
//! XInputゲームパッドデリゲート
class XInputGamepadDelegate : public GamepadDelegate
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     */
    /* ------------------------------------------------------------------------- */
    XInputGamepadDelegate(GamepadServer &server)
        : GamepadDelegate(server)
        , _padArray()
    {
        _padArray.fill(nullptr);
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      初期化処理
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    bool Initialize() noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      パッドステートの更新処理
     */
    /* ------------------------------------------------------------------------- */
    void UpdateState() noexcept override;

private:
    static PadButtonFlags ConvertButton(uint32_t xiButton) noexcept;
    static float ConvertStickValue(int16_t value) noexcept;

    static constexpr size_t kPadCount = 4;
    std::array<PadState *, kPadCount> _padArray;
};
}   // namespace MGL::Input

#endif  // MGL_GAMEPAD_DELEGATE_ENABLE_XINPUT
#endif	// INCGUARD_MGL_GAMEPAD_DELEGATE_XINPUT_H_1617258450

// vim: et ts=4 sw=4 sts=4
