// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_gamepad_delegate_iokit_hid.h
 *  \brief      MGL IOKitによるHIDゲームパッドデリゲート
 *  \date       Since: January 9, 2021. 17:32:43 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_GAMEPAD_DELEGATE_IOKIT_HID_H_1610181163
#define INCGUARD_MGL_GAMEPAD_DELEGATE_IOKIT_HID_H_1610181163

#include <mgl/mgl_environment.h>
#if defined(MGL_GAMEPAD_DELEGATE_ENABLE_IOKIT_HID)

#include <mutex>

#include <IOKit/hid/IOHIDManager.h>

#include <mgl/input/gamepad/mgl_gamepad_delegate.h>
#include <mgl/input/gamepad/mgl_gamepad_state.h>
#include <mgl/input/gamepad/iokit_hid_driver/mgl_iokit_hid_driver.h>
#include <mgl/stl/mgl_stl_containers.h>

namespace MGL::Input
{
//! IOKitによるHIDゲームパッドデリゲート
class IOKitHIDGamepadDelegate : public GamepadDelegate
{
public:
    IOKitHIDGamepadDelegate(GamepadServer &server) noexcept;
    ~IOKitHIDGamepadDelegate() noexcept;

    bool Initialize() noexcept override;
    void UpdateState() noexcept override;

private:
    struct IOKitHIDState
    {
        PadState *state;
        STL::unique_ptr<IOKitHID::GamepadDriver> driver;
        IOHIDDeviceRef device;
        
        IOKitHIDState()
            : state(nullptr)
            , driver(nullptr)
            , device(nullptr)
        {}        
    };
    
    static void CallbackDeviceMatching(void *inContext, IOReturn inResult, void *inSender, IOHIDDeviceRef inIOHIDDeviceRef) noexcept;
    static void CallbackDeviceRemoval(void *inContext, IOReturn inResult, void *inSender, IOHIDDeviceRef inIOHIDDeviceRef) noexcept;
    
    bool AddDevice(IOHIDDeviceRef device) noexcept;
    void RemoveDevice(IOHIDDeviceRef device) noexcept;
    
    bool GetDevicePropertyValue(int32_t &value, const IOHIDDeviceRef device, const CFStringRef key) const noexcept;
    bool GetDevicePropertyString(STL::string &string, const IOHIDDeviceRef device, const CFStringRef key) const noexcept;

    IOHIDManagerRef _hidManager;
    PadPriority _priority;
    
    STL::list<STL::unique_ptr<IOKitHIDState>> _hidStateList;
    std::mutex _mutex;
};
}   // namespace MGL::Input

#endif  // MGL_GAMEPAD_DELEGATE_ENABLE_IOKIT_HID
#endif	// INCGUARD_MGL_GAMEPAD_DELEGATE_IOKIT_HID_H_1610181163

// vim: et ts=4 sw=4 sts=4
