// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_gamepad_delegate_directinput.h
 *  \brief      MGL DirectInput用デリゲート
 *  \date       Since: April 1, 2021. 19:10:37 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_GAMEPAD_DELEGATE_DIRECTINPUT_H_1617271837
#define INCGUARD_MGL_GAMEPAD_DELEGATE_DIRECTINPUT_H_1617271837

#include <mgl/mgl_environment.h>
#if defined(MGL_GAMEPAD_DELEGATE_ENABLE_DIRECTINPUT)

//! 使用するDirectInputのバージョン
#define DIRECTINPUT_VERSION     0x0800
#include <dinput.h>
#include <vector>
#include <atlbase.h>

#include <mgl/input/gamepad/mgl_gamepad_delegate.h>
#include <mgl/input/gamepad/mgl_gamepad_state.h>
#include <mgl/event/mgl_event.h>

namespace MGL::Input
{
//! DirectInput用デリゲート
class DirectInputGamepadDelegate : public GamepadDelegate
{
public:
    DirectInputGamepadDelegate(GamepadServer &server) noexcept;

    bool Initialize() noexcept override;
    void UpdateState() noexcept override;

private:
    bool AddDevice(const DIDEVICEINSTANCE *deviceInstance) noexcept;
    static void ApplyState(PadState *state, const DIJOYSTATE2 &diState) noexcept;

    static void OnEventDeviceArrival(void *callbackArg, void *notifyArg) noexcept;
    static void OnEventDeviceRemove(void *callbackArg, void *notifyArg) noexcept;

    CComPtr<IDirectInput8> _dinput{nullptr};

    struct DirectInputGamepad
    {
        PadState *state;
        CComPtr<IDirectInputDevice8> device;
        GUID guid;
    };

    std::vector<DirectInputGamepad> _padArray;
    Event::Handle _eventDeviceArrival;
    Event::Handle _eventDeviceRemove;
};
}   // namespace MGL::Input

#endif  // MGL_GAMEPAD_DELEGATE_ENABLE_DIRECTINPUT
#endif	// INCGUARD_MGL_GAMEPAD_DELEGATE_DIRECTINPUT_H_1617271837

// vim: et ts=4 sw=4 sts=4
