// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_gamepad_delegate.h
 *  \brief      MGL ゲームパッド用デリゲート基底クラス
 *  \date       Since: January 3, 2021. 16:51:20 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_GAMEPAD_DELEGATE_H_1609660280
#define INCGUARD_MGL_GAMEPAD_DELEGATE_H_1609660280

namespace MGL::Input
{
class GamepadServer;

//! ゲームパッド用デリゲート基底クラス
class GamepadDelegate
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     *  \param[in]  server  ゲームパッドサーバの参照
     */
    /* ------------------------------------------------------------------------- */
    GamepadDelegate(GamepadServer &server) noexcept
        : _server(server)
    {}

    virtual ~GamepadDelegate() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      初期化処理
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool Initialize() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      パッドステートの更新処理
     */
    /* ------------------------------------------------------------------------- */
    virtual void UpdateState() noexcept = 0;

protected:
    GamepadServer &_server;    //!< ゲームパッドサーバへの参照
};
}    // namespace MGL::Input
#endif    // INCGUARD_MGL_GAMEPAD_DELEGATE_H_1609660280

// vim: et ts=4 sw=4 sts=4
