// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_iokit_hid_generic_driver.h
 *  \brief      MGL IOKit HID 標準ゲームパッドドライバ
 *  \date       Since: January 11, 2021. 17:53:03 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_IOKIT_HID_GENERIC_DRIVER_H_1610355183
#define INCGUARD_MGL_IOKIT_HID_GENERIC_DRIVER_H_1610355183

#include <mgl/input/gamepad/iokit_hid_driver/mgl_iokit_hid_driver.h>
#if defined(MGL_GAMEPAD_DELEGATE_ENABLE_IOKIT_HID)

#include <mgl/input/gamepad/iokit_hid_driver/mgl_iokit_hid_axis.h>

namespace MGL::Input::IOKitHID
{
//! IOKit HID 標準ゲームパッドドライバ
class GenericGamepadDriver : public GamepadDriver
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      このドライバが対応しているデバイスかを取得
     *  \param[in]  vendorID    デバイスのベンダID
     *  \param[in]  productID   デバイスのプロダクトID
     *  \retval     true        管理可能
     *  \retval     false       管理不可能
     */
    /* ------------------------------------------------------------------------- */
    static constexpr bool IsManageable([[maybe_unused]] int32_t vendorID, [[maybe_unused]] int32_t productID) noexcept
    {
        // どのドライバも対応していない場合に使用する標準ドライバなので常にtrue
        return true;
    }

    bool Initialize(IOHIDDeviceRef device) noexcept override;
    bool UpdateState(MGL::Input::PadState &state, IOHIDDeviceRef device) noexcept override;

private:
    Axis _axisX;
    Axis _axisY;
    Axis _axisZ;
    Axis _axisRz;

    bool _hasDPad{false};
    bool _hasHatswitch{false};
};
}    // namespace MGL::Input::IOKitHID

#endif    // MGL_GAMEPAD_DELEGATE_ENABLE_IOKIT_HID
#endif    // INCGUARD_MGL_IOKIT_HID_GENERIC_DRIVER_H_1610355183

// vim: et ts=4 sw=4 sts=4
