// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_initializer_win32.h
 *  \brief      MGL Win32用イニシャライザクラス
 *  \date       Since: March 27, 2021. 3:31:42 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_INITIALIZER_WIN32_H_1616783502
#define INCGUARD_MGL_INITIALIZER_WIN32_H_1616783502

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_WIN32)

#include <mgl/initialize/mgl_initializer_delegate.h>
#include <mgl/stl/mgl_stl_memory.h>
#include <mgl/stl/mgl_stl_string.h>

namespace MGL::Win32
{
//! MGL Win32用イニシャライザクラス
class Initializer : public MGL::InitializerDelegate
{
public:
    Initializer() noexcept;

    [[nodiscard]] STL::unique_ptr<Render::Renderer2DDelegate> MakeRenderer2D() const noexcept override;
    [[nodiscard]] STL::unique_ptr<Render::TextureGenerator> MakeTextureGenerator() const noexcept override;
    void MakeTextureLoader(Render::TextureStorage &textureStorage) const noexcept override;

    [[nodiscard]] STL::unique_ptr<Audio::Renderer> MakeAudioRenderer() const noexcept override;    

    File::Result DidInitializeFileSystem() noexcept override;

    [[nodiscard]] STL::unique_ptr<Input::KeyboardDelegate> MakeKeyboardDelegate() const noexcept override;
    [[nodiscard]] STL::unique_ptr<Input::MouseDelegate> MakeMouseDelegate() const noexcept override;
    bool DidInitializeGamepadServer(Input::GamepadServer &server) const noexcept override;

    [[nodiscard]] STL::unique_ptr<System::ApplicationModuleInterface> MakeApplicationModule() const noexcept override;
    [[nodiscard]] STL::unique_ptr<System::ChronoModuleInterface> MakeChronoModule() const noexcept override;
    [[nodiscard]] STL::unique_ptr<System::DebugModuleInterface> MakeDebugModule() const noexcept override;
    [[nodiscard]] STL::unique_ptr<System::LocaleModuleInterface> MakeLocaleModule() const noexcept override;
    [[nodiscard]] STL::unique_ptr<System::WindowModuleInterface> MakeWindowModule() const noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      XInputゲームパッドの有効フラグの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableXInputGamepad(bool isEnabled) noexcept
    {
        _isEnabledXInputGamepad = isEnabled;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      DirectInputゲームパッドの有効フラグの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableDirectInputGamepad(bool isEnabled) noexcept
    {
        _isEnabledDirectInputGamepad = isEnabled;
    }

private:
    Render::RendererType _rendererType;

    [[nodiscard]] static STL::string GetWorkDirectory() noexcept;
    [[nodiscard]] static STL::string GetExecDirectory() noexcept;

    bool _isEnabledXInputGamepad;
    bool _isEnabledDirectInputGamepad;
};
}   // namespace MGL::Win32

#endif  // MGL_TARGET_WIN32
#endif	// INCGUARD_MGL_INITIALIZER_WIN32_H_1616783502

// vim: et ts=4 sw=4 sts=4
