// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_initializer_tvos.h
 *  \brief      MGL tvOS用イニシャライザクラス
 *  \date       Since: March 19, 2021. 18:21:04 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_INITIALIZER_TVOS_H_1616145664
#define INCGUARD_MGL_INITIALIZER_TVOS_H_1616145664

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_TVOS)

#include <mgl/initialize/mgl_initializer_delegate.h>

namespace MGL::Apple::tvOS
{
//! tvOS用イニシャライザクラス
class Initializer : public MGL::InitializerDelegate
{
public:
    Initializer() noexcept;
    
    STL::unique_ptr<Render::Renderer2DDelegate> MakeRenderer2D() const noexcept override;
    STL::unique_ptr<Render::TextureGenerator> MakeTextureGenerator() const noexcept override;
    void MakeTextureLoader(Render::TextureStorage &textureStorage) const noexcept override;

    STL::unique_ptr<Audio::Renderer> MakeAudioRenderer() const noexcept override;
    
    File::Result DidInitializeFileSystem() noexcept override;
    
    STL::unique_ptr<System::ApplicationModuleInterface> MakeApplicationModule() const noexcept override;
    STL::unique_ptr<System::ChronoModuleInterface> MakeChronoModule() const noexcept override;
    STL::unique_ptr<System::DebugModuleInterface> MakeDebugModule() const noexcept override;
    STL::unique_ptr<System::LocaleModuleInterface> MakeLocaleModule() const noexcept override;
    
    STL::unique_ptr<Input::KeyboardDelegate> MakeKeyboardDelegate() const noexcept override;
    bool DidInitializeGamepadServer(Input::GamepadServer &server) const noexcept override;
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      GameControllerフレームワークによるゲームパッドデリゲートを有効にするかの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableGCGamepadDelegate(bool isEnabled) noexcept
    {
        _isEnabledGCGamepadDelegate = isEnabled;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      キーボードを有効にするかの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableKeyboard(bool isEnabled) noexcept
    {
        _isEnabledKeyboard = isEnabled;
    }
    
private:
    bool _isEnabledGCGamepadDelegate;
    bool _isEnabledKeyboard;
};
}   // namespace MGL::Apple::tvOS


#endif  // MGL_TARGET_TVOS
#endif	// INCGUARD_MGL_INITIALIZER_TVOS_H_1616145664

// vim: et ts=4 sw=4 sts=4
