// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_initializer_macos.h
 *  \brief      MGL macOS用イニシャライザクラス
 *  \date       Since: March 18, 2021. 15:27:22 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_INITIALIZER_MACOS_H_1616048842
#define INCGUARD_MGL_INITIALIZER_MACOS_H_1616048842

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_MACOS)

#include <mgl/initialize/mgl_initializer_delegate.h>
#include <mgl/render/metal/mgl_metal_defs.h>
#include <mgl/render/metal/mgl_metal_renderer_2d.h>

namespace MGL::Apple::macOS
{
//! macOS用イニシャライザクラス
class Initializer : public MGL::InitializerDelegate
{
public:
    Initializer() noexcept;
    
    STL::unique_ptr<Render::Renderer2DDelegate> MakeRenderer2D() const noexcept override;
    STL::unique_ptr<Render::TextureGenerator> MakeTextureGenerator() const noexcept override;
    void MakeTextureLoader(Render::TextureStorage &textureStorage) const noexcept override;

    STL::unique_ptr<Audio::Renderer> MakeAudioRenderer() const noexcept override;
    
    File::Result DidInitializeFileSystem() noexcept override;
    
    STL::unique_ptr<System::ApplicationModuleInterface> MakeApplicationModule() const noexcept override;
    STL::unique_ptr<System::ChronoModuleInterface> MakeChronoModule() const noexcept override;
    STL::unique_ptr<System::DebugModuleInterface> MakeDebugModule() const noexcept override;
    STL::unique_ptr<System::LocaleModuleInterface> MakeLocaleModule() const noexcept override;
    STL::unique_ptr<System::WindowModuleInterface> MakeWindowModule() const noexcept override;
    
    STL::unique_ptr<Input::KeyboardDelegate> MakeKeyboardDelegate() const noexcept override;
    STL::unique_ptr<Input::MouseDelegate> MakeMouseDelegate() const noexcept override;
    bool DidInitializeGamepadServer(Input::GamepadServer &server) const noexcept override;
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      GameControllerフレームワークによるゲームパッドデリゲートを有効にするかの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableGCGamepadDelegate(bool isEnabled) noexcept
    {
        _isEnabledGCGamepadDelegate = isEnabled;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      IOKitによるHIDゲームパッドデリゲートを有効にするかの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableIOKitGamepadDelegate(bool isEnabled) noexcept
    {
        _isEnabledIOKitGamepadDelegate = isEnabled;
    }
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      GameControllerフレームワークによるキーボードデリゲートを有効にするかの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableGCKeyboardDelegate(bool isEnabled) noexcept
    {
        _isEnabledGCKeyboardDelegate = isEnabled;
    }
    
private:
    bool _isEnabledIOKitGamepadDelegate;
    bool _isEnabledGCGamepadDelegate;
    bool _isEnabledGCKeyboardDelegate;
};
}   // namespace MGL::Apple::macOS

#endif  // MGL_TARGET_MACOS
#endif	// INCGUARD_MGL_INITIALIZER_MACOS_H_1616048842

// vim: et ts=4 sw=4 sts=4
