// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_initializer_ios.h
 *  \brief      MGL iOS用イニシャライザクラス
 *  \date       Since: March 19, 2021. 18:09:07 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_INITIALIZER_IOS_H_1616144947
#define INCGUARD_MGL_INITIALIZER_IOS_H_1616144947

#include <mgl/mgl_environment.h>
#if defined(MGL_TARGET_IOS)

#include <mgl/initialize/mgl_initializer_delegate.h>

namespace MGL::Apple::iOS
{
//! iOS用イニシャライザクラス
class Initializer : public MGL::InitializerDelegate
{
public:
    Initializer() noexcept;
    
    STL::unique_ptr<Render::Renderer2DDelegate> MakeRenderer2D() const noexcept override;
    STL::unique_ptr<Render::TextureGenerator> MakeTextureGenerator() const noexcept override;
    void MakeTextureLoader(Render::TextureStorage &textureStorage) const noexcept override;
    
    STL::unique_ptr<Audio::Renderer> MakeAudioRenderer() const noexcept override;
    
    File::Result DidInitializeFileSystem() noexcept override;
    
    STL::unique_ptr<System::ApplicationModuleInterface> MakeApplicationModule() const noexcept override;
    STL::unique_ptr<System::ChronoModuleInterface> MakeChronoModule() const noexcept override;
    STL::unique_ptr<System::DebugModuleInterface> MakeDebugModule() const noexcept override;
    STL::unique_ptr<System::LocaleModuleInterface> MakeLocaleModule() const noexcept override;
    
    STL::unique_ptr<Input::KeyboardDelegate> MakeKeyboardDelegate() const noexcept override;
    STL::unique_ptr<Input::MouseDelegate> MakeMouseDelegate() const noexcept override;
    STL::unique_ptr<Input::TouchDelegate> MakeTouchDelegate() const noexcept override;
    bool DidInitializeGamepadServer(Input::GamepadServer &server) const noexcept override;
    
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      GameControllerフレームワークによるゲームパッドデリゲートを有効にするかの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableGCGamepadDelegate(bool isEnabled) noexcept
    {
        _isEnabledGCGamepadDelegate = isEnabled;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      キーボードを有効にするかの設定
     *  \param[in]  isEnabled   trueで有効
     */
    /* ------------------------------------------------------------------------- */
    constexpr void EnableKeyboard(bool isEnabled) noexcept
    {
        _isEnabledKeyboard = isEnabled;
    }

private:
    bool _isEnabledGCGamepadDelegate;
    bool _isEnabledKeyboard;
};
}   // namespace MGL::Apple::iOS


#endif  // MGL_TARGET_IOS
#endif	// INCGUARD_MGL_INITIALIZER_IOS_H_1616144947

// vim: et ts=4 sw=4 sts=4
