// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_file_mount_work.h
 *  \brief      MGL ファイルアクセスに使用するマウント毎の作業用クラス
 *  \date       Since: January 26, 2021. 9:42:05 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_FILE_MOUNT_WORK_H_1611621725
#define INCGUARD_MGL_FILE_MOUNT_WORK_H_1611621725

#include <mgl/file/mgl_file_defs.h>

namespace MGL::File
{
//! マウント毎のワークの基底クラス
class MountWork
{
public:
    /* ------------------------------------------------------------------------- */
    /**
     * \brief       コンストラクタ
     * \param[in]   key デリゲートキー
     */
    /* ------------------------------------------------------------------------- */
    constexpr MountWork(DelegateKey key) noexcept
        : _key(key)
    {
    }

    virtual ~MountWork() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /**
     * \brief       デリゲートキーの取得
     * \return      デリゲートキー
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr DelegateKey GetDelegateKey() const noexcept
    {
        return _key;
    }

private:
    DelegateKey _key;
};

//! マウント毎のワークの共有ポインタ
using SharedMountWork = std::shared_ptr<MountWork>;

}    // namespace MGL::File

#endif    // INCGUARD_MGL_FILE_MOUNT_WORK_H_1611621725

// vim: et ts=4 sw=4 sts=4
