/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_file_exception.h
 *  \brief      MGL ファイルシステム用例外クラス
 *  \date       Since: February 8, 2026. 0:52:06 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_FILE_EXCEPTION_H_1770479526
#define INCGUARD_MGL_FILE_EXCEPTION_H_1770479526

#include <exception>

#include <mgl/file/mgl_file_defs.h>
#include <mgl/stl/mgl_stl_string.h>
#include <mgl/text/mgl_text_format.h>

namespace MGL::File
{
//! ファイルシステム用例外クラス
class Exception : public std::exception
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     *  \param[in]  error   エラーコード
     *  \param[in]  what    理由を表す文字列
     */
    /* ------------------------------------------------------------------------- */
    Exception(Error error, const char *what) noexcept
        : _error(error)
        , _what(Text::Format("[MGL::File::Exception] code: {}, {}", static_cast<uint32_t>(_error), what))
    {
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      エラーコードの取得
     *  \return     エラーコード
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr Error GetError() const noexcept
    {
        return _error;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      理由の取得
     *  \return     理由を表す文字列
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] const char *what() const noexcept override
    {
        return _what.c_str();
    }

private:
    Error _error;
    STL::string _what;
};
}    // namespace MGL::File

#endif    // INCGUARD_MGL_FILE_EXCEPTION_H_1770479526

// vim: et ts=4 sw=4 sts=4
