// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_event_notifier.h
 *  \brief      MGL イベント通知
 *  \date       Since: December 23, 2020. 13:34:15 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_EVENT_NOTIFIER_H_1608698055
#define INCGUARD_MGL_EVENT_NOTIFIER_H_1608698055

#include <array>

#include <mgl/common/mgl_singleton.h>
#include <mgl/event/mgl_event_handle.h>
#include <mgl/event/mgl_event_register_list.h>
#include <mgl/event/mgl_event_types.h>
#include <mgl/stl/mgl_stl_memory.h>


namespace MGL::Event
{
//! MGL イベント通知
class Notifier final : public SharedSingleton<Notifier>
{
public:
    static STL::unique_ptr<Notifier> &GetInstanceRef() noexcept;

    Notifier() noexcept;

    bool Register(Handle &handle, NotifyType type, CallbackFunction callback, void *callbackArg = nullptr) noexcept;
    void Unregister(Handle &handle) noexcept;

    bool Notify(NotifyType type, void *notifyArg = nullptr) noexcept;

private:
    RegisterList *GetRegisterList(NotifyType type) noexcept;

    std::array<RegisterList, kValidNotifyTypeCount> _registerListArray;
};
}    // namespace MGL::Event

#endif    // INCGUARD_MGL_EVENT_NOTIFIER_H_1608698055

// vim: et ts=4 sw=4 sts=4
