// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_event.h
 *  \brief      MGL イベント
 *  \date       Since: December 21, 2020. 13:43:24 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_EVENT_H_1608525804
#define INCGUARD_MGL_EVENT_H_1608525804

#include <mgl/event/mgl_event_notifier.h>
#include <mgl/mgl_environment.h>

namespace MGL::Event
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      イベント通知の実行
 *  \param[in]  type        通知タイプ
 *  \param[in]  notifyArg   通知の引数（コールバック関数のnotifyArgに送られる）
 *  \retval     true        成功
 *  \retval     false       失敗
 *  \note
 *      同じ通知タイプのイベントを多重に呼ぶことはできず，その場合は失敗となる．
 */
/* ------------------------------------------------------------------------- */
inline bool Notify(NotifyType type, void *notifyArg = nullptr) noexcept
{
    if (!Notifier::HasInstance())
    {
        return false;
    }

    return Notifier::GetInstance().Notify(type, notifyArg);
}
}    // namespace MGL::Event

#endif    // INCGUARD_MGL_EVENT_H_1608525804

// vim: et ts=4 sw=4 sts=4
