// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio_wave_voice.h
 *  \brief      MGL WAVEボイス
 *  \date       Since: January 29, 2021. 6:34:57 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_AUDIO_WAVE_VOICE_H_1611869697
#define INCGUARD_MGL_AUDIO_WAVE_VOICE_H_1611869697

#include <mgl/audio/voice/mgl_audio_voice.h>
#include <mgl/audio/voice/mgl_audio_wave_loader.h>

#include <future>

namespace MGL::Audio
{
//! MGL WAVEボイス
class WaveVoice : public Voice
{
public:
    WaveVoice(VoiceKey key, const File::PathView &path, bool isLoop = false, uint32_t loopFrame = 0) noexcept;

    bool Load() noexcept override;
    bool GetSample(float &outDataL, float &outDataR, uint32_t trackIndex, size_t sampleFrame) const noexcept override;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ボイスの最大フレーム数を取得
     *  \param[in]  trackIndex  トラック番号
     *  \return     最大フレーム数
     */
    /* ------------------------------------------------------------------------- */
    uint32_t GetTotalFrame([[maybe_unused]] uint32_t trackIndex) const noexcept override
    {
        return _totalFrame;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      指定したトラックのループ設定を取得
     *  \param[in]  trackIndex  トラック番号
     *  \retval     true        ループあり
     *  \retval     false       ループなし
     */
    /* ------------------------------------------------------------------------- */
    bool IsLoop([[maybe_unused]] uint32_t trackIndex) const noexcept override
    {
        return _isLoop;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      指定したトラックのループフレームを取得
     *  \param[in]  trackIndex  トラック番号
     *  \return     ループフレーム
     */
    /* ------------------------------------------------------------------------- */
    uint32_t GetLoopFrame([[maybe_unused]] uint32_t trackIndex) const noexcept override
    {
        return _loopFrame;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      ボイスが持つトラックの数を取得
     *  \return     トラック数
     */
    /* ------------------------------------------------------------------------- */
    uint32_t GetTrackCount() const noexcept override
    {
        return 1;
    }

private:
    bool LoadWaveFile() noexcept;

    File::Path _path;
    WaveLoader::Format _format{};
    bool _isLoop;
    STL::unique_ptr<std::byte[]> _data{nullptr};
    size_t _dataSize{0};
    uint32_t _totalFrame{0};
    uint32_t _loopFrame;
    std::future<void> _future;
};
}    // namespace MGL::Audio

#endif    // INCGUARD_MGL_AUDIO_WAVE_VOICE_H_1611869697

// vim: et ts=4 sw=4 sts=4
