// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio_renderer_xaudio2.h
 *  \brief      MGL XAudio2オーディオレンダラ
 *  \date       Since: April 2, 2021. 16:47:32 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_AUDIO_RENDERER_XAUDIO2_H_1617349652
#define INCGUARD_MGL_AUDIO_RENDERER_XAUDIO2_H_1617349652

#include <mgl/mgl_environment.h>
#if defined(MGL_AUDIO_RENDERER_ENABLE_XAUDIO2)

#include <mgl/audio/renderer/mgl_audio_renderer.h>
#include <mgl/stl/mgl_stl_memory.h>

#include <atlbase.h>
#include <xaudio2.h>

namespace MGL::Audio
{
//! XAudio2オーディオレンダラ
class XAudio2Renderer : public Renderer
    , IXAudio2VoiceCallback
{
public:
    XAudio2Renderer() noexcept;
    ~XAudio2Renderer() noexcept;

    bool Initialize(InitializeMode initMode, RenderingFunction rendering) noexcept override;

private:
    void STDMETHODCALLTYPE OnVoiceProcessingPassStart(UINT32 samplesRequired) override;

    // 未使用コールバック関数
    void STDMETHODCALLTYPE OnVoiceProcessingPassEnd(void) override {}
    void STDMETHODCALLTYPE OnStreamEnd(void) override {}
    void STDMETHODCALLTYPE OnBufferStart(void * /*pBufferContext*/) override {}
    void STDMETHODCALLTYPE OnBufferEnd(void * /*pBufferContext*/) override {}
    void STDMETHODCALLTYPE OnLoopEnd(void * /*pBufferContext*/) override {}
    void STDMETHODCALLTYPE OnVoiceError(void * /*pBufferContext*/, HRESULT /*Error*/) override {}

    bool _isInitialize;                         //!< 初期化済みフラグ
    CComPtr<IXAudio2> _xaudio2;                 //!< XAudio2本体
    IXAudio2MasteringVoice *_masteringVoice;    //!< マスタリングボイス
    IXAudio2SourceVoice *_sourceVoice;          //!< ソースボイス

    static constexpr int kRingBufferCount = 2;    //!< リングバッファの数
    STL::unique_ptr<std::byte[]> _ringBuffer[kRingBufferCount];
    int _currentRingBuffer;    //!< 現在のバッファ
};
}    // namespace MGL::Audio

#endif    // MGL_AUDIO_RENDERER_ENABLE_XAUDIO2
#endif    // INCGUARD_MGL_AUDIO_RENDERER_XAUDIO2_H_1617349652

// vim: et ts=4 sw=4 sts=4
