// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio_renderer_apple_coreaudio.h
 *  \brief      MGL Apple CoreAudio オーディオレンダラ
 *  \date       Since: January 17, 2021. 5:46:11 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_AUDIO_RENDERER_APPLE_COREAUDIO_H_1610829971
#define INCGUARD_MGL_AUDIO_RENDERER_APPLE_COREAUDIO_H_1610829971

#include <mgl/mgl_environment.h>
#if defined(MGL_AUDIO_RENDERER_ENABLE_APPLE_COREAUDIO)

#include <AudioToolbox/AudioToolbox.h>
#include <atomic>

#include <mgl/audio/renderer/mgl_audio_renderer.h>
#include <mgl/event/mgl_event.h>

namespace MGL::Audio
{
//! Apple CoreAudio オーディオレンダラ
class AppleCoreAudioRenderer : public Renderer
{
public:
    AppleCoreAudioRenderer() noexcept;

    virtual ~AppleCoreAudioRenderer() noexcept;

    bool Initialize(InitializeMode initMode, RenderingFunction rendering) noexcept override;

private:
    std::atomic<bool> _isInitialize;                  //!< 初期化済みフラグ
    Event::Handle _eventSuspend;                      //!< 中断イベント
    Event::Handle _eventResume;                       //!< 再開イベント
    AudioStreamBasicDescription _outputFormatASBD;    //!< 出力フォーマット
    AudioUnit _outUnit;                               //!< 出力用オーディオユニット

    static OSStatus renderCallback(
        void *inRefCon,
        AudioUnitRenderActionFlags *ioActionFlags,
        const AudioTimeStamp *inTimeStamp,
        UInt32 inBusNumber,
        UInt32 inNumberFrames,
        AudioBufferList *ioData) noexcept;

    static void OnEventSuspend(void *callbackArg, void *notifyArg) noexcept;
    static void OnEventResume(void *callbackArg, void *notifyArg) noexcept;
};

}    // namespace MGL::Audio

#endif    // MGL_AUDIO_RENDERER_ENABLE_APPLE_COREAUDIO
#endif    // INCGUARD_MGL_AUDIO_RENDERER_APPLE_COREAUDIO_H_1610829971

// vim: et ts=4 sw=4 sts=4
