// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio_renderer.h
 *  \brief      MGL オーディオレンダラ
 *  \date       Since: January 17, 2021. 5:35:01 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_AUDIO_RENDERER_H_1610829301
#define INCGUARD_MGL_AUDIO_RENDERER_H_1610829301

#include <mgl/audio/mgl_audio_defs.h>
#include <mgl/stl/mgl_stl_containers.h>

namespace MGL::Audio
{
//! レンダリング関数の型
using RenderingFunction = void (*)(void **outData, size_t outDataCount, const DataFormat &dataFormat, size_t frameCount) noexcept;

//! オーディオレンダラクラス
class Renderer
{
public:
    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      コンストラクタ
     */
    /* ------------------------------------------------------------------------- */
    Renderer() noexcept = default;

    virtual ~Renderer() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      出力フォーマットを取得
     *  \return     出力フォーマット
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr const DataFormat &GetOutputFormat() const noexcept
    {
        return _outputFormat;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      初期化処理
     *  \param[in]  initMode    初期化タイプ
     *  \param[in]  rendering   レンダリングを行う関数
     *  \retval     true        成功
     *  \retval     false       失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool Initialize(InitializeMode initMode, RenderingFunction rendering) noexcept = 0;


protected:
    RenderingFunction _rendering{nullptr};    //!< レンダリング関数
    DataFormat _outputFormat;                 //!< 出力フォーマット
};

}    // namespace MGL::Audio
#endif    // INCGUARD_MGL_AUDIO_RENDERER_H_1610829301

// vim: et ts=4 sw=4 sts=4
