// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio_voice_storage.h
 *  \brief      MGL オーディオボイスストレージ
 *  \date       Since: January 16, 2021. 2:42:25 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_AUDIO_VOICE_STORAGE_H_1610732545
#define INCGUARD_MGL_AUDIO_VOICE_STORAGE_H_1610732545

#include <mutex>

#include <mgl/audio/voice/mgl_audio_voice.h>
#include <mgl/stl/mgl_stl_containers.h>

namespace MGL::Audio
{
//! ボイスストレージ用のマップの型
using VoiceMap = STL::unordered_map<VoiceKey, SharedVoice>;

//! ボイスストレージクラス
class VoiceStorage
{
public:
    bool Add(const SharedVoice &voice) noexcept;
    SharedVoice Get(VoiceKey key) noexcept;
    bool Remove(VoiceKey key) noexcept;

private:
    VoiceMap _voices;
    std::mutex _mutex;
};
};    // namespace MGL::Audio

#endif    // INCGUARD_MGL_AUDIO_VOICE_STORAGE_H_1610732545

// vim: et ts=4 sw=4 sts=4
