// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio_sampletype_convert.h
 *  \brief      MGL オーディオサンプルの変換用関数
 *  \date       Since: January 17, 2021. 6:47:14 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_AUDIO_SAMPLETYPE_CONVERT_H_1610833634
#define INCGUARD_MGL_AUDIO_SAMPLETYPE_CONVERT_H_1610833634

#include <mgl/audio/mgl_audio_defs.h>

namespace MGL::Audio::SampleTypeConvert
{
//! データ書き込み用関数の型
using WriteDataFunction = void (*)(void **outDataL, void **outDataR, const DataFormat &dataFormat, float inDataL, float inDataR) noexcept;

void WriteDataToSigned8(void **outDataL, void **outDataR, const DataFormat &dataFormat, float inDataL, float inDataR) noexcept;
void WriteDataToSigned16(void **outDataL, void **outDataR, const DataFormat &dataFormat, float inDataL, float inDataR) noexcept;
void WriteDataToUnsigned8(void **outDataL, void **outDataR, const DataFormat &dataFormat, float inDataL, float inDataR) noexcept;
void WriteDataToUnsigned16(void **outDataL, void **outDataR, const DataFormat &dataFormat, float inDataL, float inDataR) noexcept;
void WriteDataToFloat(void **outDataL, void **outDataR, const DataFormat &dataFormat, float inDataL, float inDataR) noexcept;

void *ReadSample(float *outDataL,
                 float *outDataR,
                 void *inData,
                 SampleType sampleType,
                 int bitPerSample,
                 int channelCount);

WriteDataFunction GetWriteDataFunction(const DataFormat &dataFormat) noexcept;
}    // namespace MGL::Audio::SampleTypeConvert
#endif    // INCGUARD_MGL_AUDIO_SAMPLETYPE_CONVERT_H_1610833634

// vim: et ts=4 sw=4 sts=4
