// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio_fade.h
 *  \brief      MGL フェード処理
 *  \date       Since: January 31, 2021. 16:01:32 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_AUDIO_FADE_H_1612076492
#define INCGUARD_MGL_AUDIO_FADE_H_1612076492

#include <cstdint>
#include <mutex>

namespace MGL::Audio
{
//! フェード処理クラス
class Fade
{
public:
    Fade() noexcept = default;

    void Start(float currentVolume, float targetVolume, float fadeTimeSec, float samplesPerSec, bool isAutoStop) noexcept;
    bool Update(float &volume) noexcept;
    void Cancel() noexcept;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      有効状態を取得
     *  \retval     true    有効
     *  \retval     false   無効
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr bool IsActive() const noexcept
    {
        return _isActive;
    }

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      自動停止フラグを取得
     *  \return     自動停止フラグ
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] constexpr bool IsAutoStop() const noexcept
    {
        return _isAutoStop;
    }

private:
    bool _isActive{false};             // フェード実行中フラグ
    bool _isAutoStop{false};           // フェード終了時に自動で停止するかのフラグ
    float _targetVolume{0.0f};         // フェード後の音量
    float _addVolumePerFrame{0.0f};    // 1フレームあたりの音量の加算量
    std::mutex _mutex;                 // ミューテックス
};
}    // namespace MGL::Audio

#endif    // INCGUARD_MGL_AUDIO_FADE_H_1612076492

// vim: et ts=4 sw=4 sts=4
