// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_audio.h
 *  \brief      MGL オーディオ
 *  \date       Since: February 3, 2021. 18:17:00 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_AUDIO_H_1612343820
#define INCGUARD_MGL_AUDIO_H_1612343820

#include <mgl/audio/mgl_audio_player.h>
#include <mgl/audio/mgl_audio_source.h>

namespace MGL::Audio
{
/* ------------------------------------------------------------------------- */
/*!
 *  \brief      ボイスの読み込み
 *  \tparam     VoiceClass  読み込むボイスの型
 *  \param[in]  args        ボイスのコンストラクタの引数
 *  \retval     true        成功
 *  \retval     false       失敗
 */
/* ------------------------------------------------------------------------- */
template <class VoiceClass, class... Args>
std::weak_ptr<VoiceClass> LoadVoice(Args... args) noexcept
{
    auto voice = STL::make_shared<VoiceClass>(args...);
    if (!Player::GetInstance().Load(voice))
    {
        return std::weak_ptr<VoiceClass>();
    }

    return voice;
}

bool UnloadVoice(VoiceKey key) noexcept;
void SetMasterVolume(float volume) noexcept;
[[nodiscard]] float GetMasterVolume() noexcept;
void SetVoiceVolume(VoiceKey voiceKey, float volume) noexcept;
[[nodiscard]] float GetVoiceVolume(VoiceKey voiceKey) noexcept;

}    // namespace MGL::Audio

#endif    // INCGUARD_MGL_AUDIO_H_1612343820

// vim: et ts=4 sw=4 sts=4
