// SPDX-License-Identifier: Zlib
/* ------------------------------------------------------------------------- */
/*!
 *  \file       mgl_achievement_server_delegate.h
 *  \brief      MGL 実績サーバデリゲート
 *  \date       Since: September 8, 2021. 12:31:36 JST.
 *  \author     Acerola
 */
/* ------------------------------------------------------------------------- */

#ifndef INCGUARD_MGL_ACHIEVEMENT_SERVER_DELEGATE_H_1631071896
#define INCGUARD_MGL_ACHIEVEMENT_SERVER_DELEGATE_H_1631071896

#include <mgl/achievement/mgl_achievement_defs.h>

namespace MGL::Achievement
{
//! MGL 実績サーバデリゲートクラス
class ServerDelegate
{
public:
    virtual ~ServerDelegate() noexcept = default;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      初期化処理
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool Initialize() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      デリゲートの初期化が完了しているかを取得
     *  \retval     true    完了している
     *  \retval     false   完了していない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual bool IsInitialized() const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      デリゲートが処理中かを取得
     *  \retval     true    処理中
     *  \retval     false   処理中でない
     */
    /* ------------------------------------------------------------------------- */
    [[nodiscard]] virtual bool IsProcessing() const noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      実績データを取得
     *  \param[in]  identifier      実績の識別子
     *  \return     識別子に対応した実績データ．存在しない場合はnullptr
     */
    /* ------------------------------------------------------------------------- */
    virtual AchievementData *GetAchievementData(Identifier identifier) noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      実績データの取得
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool FetchRequests() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      実績データの送信
     *  \retval     true    成功
     *  \retval     false   失敗
     */
    /* ------------------------------------------------------------------------- */
    virtual bool ReportRequests() noexcept = 0;

    /* ------------------------------------------------------------------------- */
    /*!
     *  \brief      実績のクリア
     *  \retval     true    成功
     *  \retval     false   失敗
     *  \note       主にデバッグに使用
     */
    /* ------------------------------------------------------------------------- */
    virtual bool Clear() noexcept = 0;
};
}   // namespace MGL::Achievement

#endif	// INCGUARD_MGL_ACHIEVEMENT_SERVER_DELEGATE_H_1631071896

// vim: et ts=4 sw=4 sts=4
