#/usr/bin/env sh

DRY_RUN=0

for i
do
    case $i in
        "--dry") DRY_RUN=1
    esac
done

find ./ -type f | egrep '\.(c|cc|cpp|h|hpp|m|mm)$' | while read file
do
    result=`nkf --guess "${file}"`
    if [ "${result}" != "UTF-8 (LF)" ]; then
        if [ "${result}" != "ASCII (LF)" ]; then
            if [ ${DRY_RUN} -eq 0 ]; then
                nkf --overwrite  -w -d "${file}"
                echo -n 'convert: '
            fi
            echo ${file}: ${result}
        fi
    fi
done

exit 0
